<?php

namespace App\Modules\Legal\Migrations\companyLawsuits;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CompanyLawsuits extends Model 
{

    protected $table = 'legal_company_lawsuits';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function judicialDepartment()
    {
        return $this->belongsTo('JudicialDepartment', 'judicial_department_id');
    }

    public function execution()
    {
        return $this->belongsTo('CompanyLawsuitExecutions', 'execution_id');
    }

    public function customer()
    {
        return $this->belongsTo('Customer', 'customer_id');
    }

}